-- EXAMEN DE LABORATORIO DE PROG. IV (DECLARATIVA) , NOV.96
-- SEGUNDO INGENIERIA TECNICA (GESTION Y SISTEMAS)

data Cola a = Ult a | (Cola a) :> a
-- por ejemplo, en la cola 	Ult 3 :> 2) :> 1 
-- el ultimo elemento es "3";
-- la operacin de insercion y borrado seran: 
-- 	en_cola 4 ((Ult 3 :> 2) :> 1 ) -> ((Ult 4 :> 3) :> 2) :> 1 
--      de_cola (Ult 3 :> 2) :> 1 )    -> ( (Ult 3 :> 2 , 1 )
-- definir las funciones de insercin y borrado

en_cola :: a -> Cola a -> Cola a
--en_cola x (Ult y)  = Ult x :> y
--en_cola x (c :> y) = (en_cola x c) :> y 

de_cola ::  Cola a -> ( Cola a, a)

de_cola (c :> x) = (c,x)

-- y la funcion mapCola que aplica una funcion a todos los elementos de una cola
mapCola :: (a -> b) -> Cola a -> Cola b
mapCola f (Ult x)  = Ult (f x)
mapCola f (c :> x) = (mapCola f c) :> (f x)
-- y demostrar por induccin estructural que
--  mapCola f ( encola x c) = encola (f x) (mapCola c)


-- Sea ahora la siguiente funcion de reduccion de colas, donde el segundo argumento
-- es una operacion a realizar cuando la cola tenga un solo elemento

redCola :: (a->b->b) -> (a->b) -> Cola a -> b
redCola _ g (Ult x) 	= g x
redCola f g (c :> y)	= f y (redCola f g c)



-- Uilizando la reduccin anterior, definir la funcion en_cola y la funcion que
-- pasa una lista a una cola
en_cola x c = redCola ( flip  (:>) ) (\y -> (Ult x) :> y) c
-- o tambien, de forma ms compacta
--en_cola = ( redCola . flip ) (:>) . (:>) . Ult

c_a_l :: Cola a -> [a]
--	c_a_l ( (Ult 3 :> 2) :> 1 ) ->  [1,2,3]
c_a_l = redCola (:) (:[]) 

-- Definir tambien funcion que inivierten colas y fusionan dos colas
inversa :: Cola a -> Cola a
-- inversa (Ult 3 :> 2) :> 1   -> (Ult 1 :> 2) :> 3
inversa  = redCola en_cola Ult

pertenece :: (Eq a) => a -> Cola a -> Bool
pertenece x = redCola ((||). (x==) ) (x==)


fusion :: Cola a -> Cola a -> Cola a
fusion = (redCola . flip) (:>) . (:>)  
-- fusion ((Ult 3 :> 2) :> 1 )  ( Ult 5 :> 4)   -> (((Ult 3 :> 2) :> 1) :> 5) :> 4 


-- definir, utilizando "foldl", una funcin para pasar una lista a una cola
l_a_c :: [a] -> Cola a
l_a_c (x:xs) = foldl (flip en_cola) (Ult x) xs



separar c = (p,i) where (_,p,i) = separar' c
separar' (Ult x :> y ) 			= (0,Ult x, Ult y)
separar' ((Ult x :> y) :> z ) 		= (1,Ult x :> z, Ult y)
separar' ((c :> y) :> z ) 
	| i==0 		= (0,p :> y, p' :> z)
	| otherwise	= (1,p :> z, p' :> y)			
		where (i, p,p') = separar' c

mezcla :: Ord a => Cola a -> Cola a -> Cola a
mezcla = redCola (>>>) . (flip (>>>))
 
y >>> (Ult x)
	| x >=y 	= Ult x :> y
	| otherwise	= Ult y :> x
y >>> (c :> x)
	| x >= y	= (c :> x) :> y
	| otherwise	= (y >>> c) :> x

ordena :: Ord a => Cola a -> Cola a
ordena = redCola (mezcla . Ult ) Ult



